/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import com.aptana.editor.common.IPartitionScannerSwitchStrategy;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.SequenceCharacterScanner;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class SubPartitionScanner
implements ISubPartitionScanner {
    private static final IToken DEFAULT_TOKEN = new Token((Object)"__dftl_partition_content_type");
    private IPredicateRule[] rules;
    private IToken defaultToken;
    private Set<String> contentTypes = new HashSet<String>();
    private SequenceCharacterScanner characterScanner;

    public SubPartitionScanner(IPredicateRule[] rules, String[] contentTypes, IToken defaultToken) {
        this.rules = rules;
        this.contentTypes.addAll(Arrays.asList(contentTypes));
        this.defaultToken = defaultToken != null ? defaultToken : DEFAULT_TOKEN;
    }

    public void initCharacterScanner(ICharacterScanner baseCharacterScanner, IPartitionScannerSwitchStrategy switchStrategy) {
        this.characterScanner = new SequenceCharacterScanner(baseCharacterScanner, switchStrategy);
    }

    public IPredicateRule[] getRules() {
        return this.rules;
    }

    public IToken getDefaultToken() {
        return this.defaultToken;
    }

    public ICharacterScanner getCharacterScanner() {
        return this.characterScanner;
    }

    public boolean foundSequence() {
        return this.characterScanner.foundSequence();
    }

    public boolean doResetRules() {
        return false;
    }

    public boolean hasContentType(String contentType) {
        return this.contentTypes.contains(contentType);
    }

    public void setLastToken(IToken token) {
    }

    public IToken getLastToken() {
        return null;
    }

    public IToken getResumeToken() {
        return null;
    }
}

